<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\WhoopsHandlers;

use apexl\Io\modules\validation\Exceptions\ValidationException;
use Whoops\Handler\Handler;

final class WhoopsValidationHandler extends Handler
{
    public function handle(): int
    {
        $exception = $this->getException();

        if ($exception instanceof ValidationException) {
            $this->getRun()->sendHttpCode($exception->getCode());
            header('Content-Type: application/json');
            echo json_encode($exception->errors);

            return Handler::QUIT;
        }

        return Handler::DONE;
    }
}