<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation;

use apexl\Io\includes\Module;
use apexl\Io\modules\system\interfaces\ProvidesMiddlewareInterface;
use apexl\Io\modules\validation\Hooks\AddWhoopsValidationHandler;
use apexl\Io\modules\validation\Middleware\ValidationMiddleware;
use app\vendor\apexl\io\src\Io\interfaces\ProvidesHooksInterface;
use Slim\App;

final class validationModule extends Module implements
    ProvidesMiddlewareInterface,
    ProvidesHooksInterface
{

    public function middleware(App $application): void
    {
        $application->add(ValidationMiddleware::class);
    }

    public function hooks(): array
    {
        return [
            AddWhoopsValidationHandler::class,
        ];
    }
}
