<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Exceptions;

use Exception;
use Psr\Http\Message\ServerRequestInterface;
use Throwable;

class ValidationException extends Exception
{
    public function __construct(
        public array $errors,
        public ServerRequestInterface $request,
        int $code = 422,
        string $message = "",
        ?Throwable $previous = null
    ) {
        parent::__construct($message, $code, $previous);
    }
}