<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\ValidationRules;

use apexl\Io\modules\validation\Interfaces\NeedsFieldNameInterface;

final readonly class Confirm extends ValidationRule implements NeedsFieldNameInterface
{
    private string $fieldName;

    public function __construct(string $field = '')
    {
        parent::__construct($field);
    }

    public function toValidatorString(): string
    {
        $confirms = $this->config ?: preg_replace('/_confirm$/', '', $this->fieldName);

        return sprintf('confirmed:%s', $confirms);
    }

    public function setFieldName(string $fieldName): void
    {
        $this->fieldName = $fieldName;
    }
}
