<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\Factories;

use apexl\Io\modules\validation\Interfaces\NeedsFieldNameInterface;
use apexl\Io\modules\validation\ValidationRules\ValidationRule;
use DI\Container;
use function apexl\Io\assertInstanceOf;

final readonly class ValidationRuleFactory
{
    public function __construct(
        private Container $container,
    ) {}

    /**
     * @param class-string<ValidationRule> $class
     */
    public function make(string $class, array|string|int $params, string $fieldName): ValidationRule
    {
        assertInstanceOf($class, ValidationRule::class);

        if (!is_array($params)) {
            $params = ['config' => $params];
        }

        $rule = $this->container->make($class, $params);

        if ($rule instanceof NeedsFieldNameInterface) {
            $rule->setFieldName($fieldName);
        }

        return $rule;
    }

}