<?php

declare(strict_types=1);

namespace apexl\Io\modules\validation\hooks;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\system\collections\MiddlewareCollectionCollection;
use apexl\Io\modules\system\services\MiddlewareCollector;
use apexl\Io\modules\validation\Middleware\ValidationMiddleware;

final readonly class AddMiddleware implements AbstractHook
{
    public function hooks(): array
    {
        return [MiddlewareCollector::HOOK__COLLECT];
    }

    public function __invoke(MiddlewareCollectionCollection $weightedMiddleware): MiddlewareCollectionCollection
    {
        $weightedMiddleware->add(ValidationMiddleware::class);

        return $weightedMiddleware;
    }
}
