<?php

namespace apexl\Io\modules\webhook\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\webhook\entities\webhookEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class webhookController extends Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function webhook($serviceName, Request $request, Response $response) {
        $webhookEntity = new webhookEntity();
        $webhookEntity->loadByName($serviceName);
        $service = new $webhookEntity->serviceNamespace();
        $result = $service->webhook($request->getParsedBody());
        return System::asJson($response, (array)$result->data ?? [], $result->status ?? 200);
    }

    public function __call($name, $args){
        return $this->webhook($name, ...$args);
    }
}