<?php

namespace apexl\Io\modules\webhook\entities;

use apexl\Io\includes\Entity;
use apexl\Io\includes\Utils;
use apexl\Io\modules\webhook\entities\operators\webhookEntityOperator;

class webhookEntity extends Entity{

    public function __construct()
    {
        parent::__construct();
        $this->setOperator(new webhookEntityOperator('webhooks'));
    }

    public function store(): Entity
    {
        //make sure the name is safe.
        $this->name = Utils::hyphenize($this->name);
        parent::__call('store', [$this->data]);
        return $this;
    }

    protected function fieldConfig(){
        return [
            "id" => [
                'name' => "ID"
            ],
            "description" => [
                'name' => "Description"
            ],
            "active" => [
                'name' => "Enabled"
            ],
            "verb" => [
                'name' => "HTTP Verb"
            ],
            "serviceNamespace" => [
                'name' => 'Service NameSpace [FQNS]'
            ]
        ];
    }
}