<?php
namespace apexl\Io\modules\webhook;

use apexl\Io\includes\System;
use apexl\Io\modules\basicApi\basicApiModule;
use apexl\Io\modules\webhook\controllers\webhookController;
use apexl\Io\modules\webhook\entities\webhookEntity;

class webhookModule extends basicApiModule {
    public function __construct()
    {
        if($this->isInstalled()) {
            parent::__construct((new webhookEntity()));
        }
    }

    public function routes() {
        parent::routes();
        $webhookEntity = new webhookEntity();
        $webhooks = $webhookEntity->loadMultiple();
        foreach ($webhooks as $endpoint) {
            if ($endpoint->name ?? FALSE) {
                $this->rootRoute(strtoupper($endpoint->verb), 'webhooks.'.strtolower($endpoint->verb).'.' . $endpoint->name, 'webhook/' . $endpoint->name, webhookController::class . ':' . $endpoint->name);
            }
        }
    }

    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }
}