<?php

namespace apexl\Io\modules\installDisplay;

use apexl\Config\Singleton;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\components\TitleTile;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\services\Output;
use apexl\Io\services\pathUtility;

use apexl\Vault\Vault;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class installDisplayController
{
    /** @var pathUtility  */
    protected $path;
    /** @var Vault  */
    protected $database;
    /** @var Singleton  */
    protected $config;

    public function __construct(pathUtility $path, Vault $database, Singleton $config)
    {
        $this->path = $path;
        $this->database = $database;
        $this->config = $config;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @return Response
     * @method GET
     */
    public function start(Request $request, Response $response): Response
    {
        //We're installing
        Output::addResponse($request, ['thing' => 'stuff']);
        //check we have the form module available to us. If so, we can use it, otherwise we need to display a message that says Manual installation required.
        if(System::$module->getModule("formBuilder") && System::$module->getModule("display")){
            // The form module is available, so we can build out our form components.
            //We're assuming the display module is also available.
            $rowWrapper = new RowWrapper();
            $rowWrapper->addClass("flex-gap");
            $form = (new FormComponent())->src(Routes::getRoutePattern('install.database.form'));
            $tile = new TitleTile();
            $tile->text("Database Details");
            $tile->addComponent($form);
            $rowWrapper->addComponent($tile);
            $this->render::setPageTitle('Install Database Details');
            $this->output::addResponse($request, $this->render::build([$rowWrapper]));

            return System::asJson($response);
        } else {

        }
        return System::asJson($response, []);
    }

    /**
     * This should only be called if the form module is available.
     * @param Request $request
     * @param Response $response
     * @return Response
     */
    public function databaseForm(Request $request, Response $response): Response
    {
        $form = new formEntity();
        $form->setId('databaseSetup');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern(''));
        $form->setSubmitText('Save and Continue');

        $form->addField((new inputField('user'))->setLabel('Username'));

        return System::asJson($response, $form->getBuiltFormArray());
    }

}