<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreateDatabaseDescribe extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('database_describe')
            ->addColumn('table_name', AdapterInterface::PHINX_TYPE_STRING, [
                'length' => false,
                'null' => false,
            ])
            ->addColumn('describe_data', AdapterInterface::PHINX_TYPE_TEXT, [
                'null' => false,
            ])
            ->addColumn('ts', AdapterInterface::PHINX_TYPE_DATETIME, [
                'null' => false,
                'default' => 'CURRENT_TIMESTAMP',
            ])
            ->addIndex(['table_name'], [
                Index::UNIQUE => true,
            ])
            ->create();
    }
}
