<?php

namespace apexl\Io\modules\migration;

use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\modules\migration\controllers\migrationController;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class migrationModule
 * @package apexl\Io\modules\migration
 */
class migrationModule extends Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('');
    }

    public function routes()
    {
        //@route /install/automatic
        $this->addRoute('POST', 'migration.migrate', 'migration/migrate', migrationController::class.':migrate');
    }

    /**
     * Provide the install modules Schema.
     * @return mixed|void
     */
    public function schema()
    {
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }
}
