<?php

namespace apexl\Io\recommendedIncludes;

use apexl\Io\includes\Module;
use apexl\Io\includes\Routes;

/**
 * Class apiModule
 * Sets a number of expected system defaults - can be overridden with config.
 * @package apexl\Io\recommendedIncludes
 */
class apiModule extends Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('/api/v'.$this->apiVersion().'/'.strtolower((string) $this->getName()));
    }

    public function addActionRoute($verb, $name, string $pattern, $callable): apiModule
    {
        $this->addRoute($verb, $name, '/action/'.ltrim($pattern, '/'), $callable);
        return $this;
    }

    public function addDataRoute($verb, $name, string $pattern, $callable): apiModule
    {
        $this->addRoute($verb, $name, '/data/'.ltrim($pattern, '/'), $callable);
        return $this;
    }
}
