<?php

namespace apexl\Io\modules\system;

use apexl\Config\Singleton as ConfigSingleton;
use apexl\Io\includes\Module;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\system\controllers\globalDataController;
use apexl\Io\modules\system\controllers\globalSystemInfo;
use apexl\Vault\Vault;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class systemModule extends Module implements HasServicesInterface
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes(): void
    {
        //Get global data
        $this->route::get('system.globaldata', '/system/globalData', globalDataController::class.':getGlobalData');

        //get all available routes
        $this->route::get('system.routes', '/system/routes', globalSystemInfo::class.':getRoutes');
    }

    public function addServices(): array
    {
        return [
            ConfigSingleton::class => fn() => ConfigSingleton::getInstance(),
            Vault::class => fn() => Vault::getInstance(),
        ];
    }
}
