<?php

declare(strict_types=1);

namespace apexl\Io\hooks;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;

readonly abstract class AbstractHook
{
    public static function handle(...$args)
    {
        return System::makeRegisteredService(static::class)(...$args);
    }

    public static function register(): void
    {
        foreach (static::hooks() as $hookOrIx => $methodsOrHook) {
            if (is_string($methodsOrHook)) {
                self::registerHook($methodsOrHook, 'handle');
                continue;
            }

            foreach ($methodsOrHook as $method) {
                self::registerHook($hookOrIx, $method);
            }
        }
    }

    /**
     * @return string[]|array<string, string[]>
     */
    abstract static protected function hooks(): array;

    private static function registerHook(string $hook, string $method): void
    {
        Hook::registerCallback(
            $hook,
            sprintf('%s:%s', static::class, $method)
        );
    }
}
