<?php

namespace apexl\Io\modules\authentication;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\Module;
use apexl\Io\modules\authentication\controllers\authenticationController;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class authenticationModule extends Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('');
    }

    public function routes(): void
    {
        //we have no db data so lets assume we're installing.
        $this->addRoute(
            HttpMethod::GET,
            'core.authenticated',
            '/authenticated',
            authenticationController::class.':authenticated'
        );
    }
}
