<?php

declare (strict_types=1);

namespace apexl\Io\enums;

use Henzeb\Enumhancer\Concerns\Getters;
use JsonSerializable;

enum SortDirection implements JsonSerializable
{
    use Getters;
    
    case ASC;
    case DESC;

    public function jsonSerialize(): string
    {
        return strtolower($this->name);
    }
}
