<?php

declare(strict_types=1);

namespace apexl\Io\requestHelper;

use Psr\Http\Message\ServerRequestInterface;

abstract class requestHelper
{
    protected ?object $body;

    public function __construct(protected ServerRequestInterface $request, protected array $args = [])
    {
        $body = $request->getParsedBody();

        $this->body = $body ? (object) $body : null;
    }

    public static function factory(ServerRequestInterface $request, array $args = []): RequestHelper
    {
        return new static($request, $args);
    }

    protected function bodyParam($name, $default = null)
    {
        return $this->body->{$name} ?? $default;
    }

    protected function arg($name, $default = null)
    {
        return $this->args[$name] ?? $default;
    }
}
