<?php

declare(strict_types=1);

namespace apexl\Io\collections;

use Arrayy\Collection\AbstractCollection;
use Symfony\Component\Console\Command\Command;
use TypeError;

///** @method Arrayy add($commandClass, $key = null) */
class CommandCollection extends AbstractCollection
{
    public function add($value, $key = null): CommandCollection
    {
        $this->assertIsCommandClass($value);

        return parent::add($value, $key);
    }

    /**
     * @throws TypeError
     */
    private function assertIsCommandClass(mixed $value): void
    {
        if (!is_string($value) || !is_a($value, Command::class, true)) {
            throw new TypeError(
                sprintf(
                    '%s must extend %s',
                    $value,
                    Command::class
                )
            );
        }
    }

    public function getType(): string
    {
        return 'string';
    }
}
