<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreateRouteCacheTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('route_cache')
            ->addColumn(
                'route',
                AdapterInterface::PHINX_TYPE_STRING,
                [
                    'limit' => 255,
                    'null' => false,
                ]
            )->addColumn(
                'name',
                AdapterInterface::PHINX_TYPE_STRING,
                [
                    'limit' => 255,
                    'null' => false,
                ]
            )->addColumn(
                'permission',
                AdapterInterface::PHINX_TYPE_STRING,
                [
                    'limit' => 255,
                    'null' => false,
                ]
            )->addColumn(
                'callback',
                AdapterInterface::PHINX_TYPE_STRING,
                [
                    'default' => 'default',
                    'limit' => 255,
                    'null' => false,
                ]
            )->addColumn(
                'active',
                AdapterInterface::PHINX_TYPE_BOOLEAN,
                [
                    'default' => 1,
                    'null' => false,
                ]
            )->addIndex('route', [
                Index::UNIQUE => true,
            ])
            ->addIndex('name')
            ->addIndex('permission')
            ->create();
    }
}
