<?php

declare(strict_types=1);

namespace app\vendor\apexl\io\src\Io\modules\system\traits;

use apexl\Io\includes\System;
use Mustache_Engine;
use Mustache_Loader_FilesystemLoader;

trait HasMustache
{
    protected function mustacheRenderToFile(string $template, string $target, array $data = []): void
    {
        file_put_contents($target, $this->mustacheRender($template, $data));
    }

    protected function mustacheRender(string $template, array $data = []): string
    {
        return $this->mustache()->render($template, $data);
    }

    protected function mustache(): Mustache_Engine
    {
        static $mustache;

        if ($mustache) {
            return $mustache;
        }

        $templateFolder = $this->mustacheTemplateFolder();

        return System::makeRegisteredService(Mustache_Engine::class, [
            'options' => [
                'loader' => new Mustache_Loader_FilesystemLoader($templateFolder),
            ],
        ]);
    }

    abstract protected function mustacheTemplateFolder(): string;
}
