<?php

namespace apexl\Io\utilityIncludes;

use apexl\Io\enums\HttpMethod;
use app\module\newtonsTrailers\Interface\PermissionInterface;
use Psr\Http\Server\MiddlewareInterface;

final class route
{
    /** @var array<int,MiddlewareInterface> */
    private readonly array $middleware;

    /** @var string|array|callable $callable */
    private readonly mixed $callable;

    public function __construct(
        private readonly string $name,
        private readonly string $pattern,
        string|array|callable $callable,
        private readonly HttpMethod $method,
        private array $args = [],
        array $middleware = []
    ) {
        $this->callable = $callable;
        $this->middleware = $middleware;
    }

    public function getMiddleware(): array
    {
        return $this->middleware;
    }

    public function setArg(string $arg, mixed $value): void
    {
        $this->args[$arg] = $value;
    }

    public function getArgs(): array
    {
        return $this->args;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getPattern(): string
    {
        return $this->pattern;
    }

    public function getCallable(): string|array|callable
    {
        return $this->callable;
    }

    public function getMethod(): HttpMethod
    {
        return $this->method;
    }

    public function getPermission(): ?PermissionInterface
    {
        $permission = $this->getArg('permission');

        if ($permission) {
            return unserialize($permission);
        }

        return null;
    }

    public function getArg(string $arg)
    {
        return $this->args[$arg] ?? null;
    }
}
