<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateVariablesTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('variables')
            ->addColumn('name', AdapterInterface::PHINX_TYPE_STRING, [
                'limit' => 255,
                'null' => false,
            ])
            ->addColumn('value', AdapterInterface::PHINX_TYPE_TEXT, [
                'null' => false,
            ])
            ->addColumn('site', AdapterInterface::PHINX_TYPE_INTEGER, [
                'default' => 1,
                'null' => false,
            ])
            ->addIndex(['site', 'name'])
            ->addIndex('site')
            ->create();
    }
}
