<?php

declare(strict_types=1);

namespace apexl\Io\hooks;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;

readonly abstract class AbstractHook
{
    public static function register(): void
    {
        foreach (static::hooks() as $hookOrIx => $methodsOrHook) {
            if (is_string($methodsOrHook)) {
                self::registerHook($methodsOrHook);
                continue;
            }

            foreach ($methodsOrHook as $method) {
                self::registerHook($hookOrIx);
            }
        }
    }

    /**
     * @return string[]|array<string, string[]>
     */
    abstract static protected function hooks(): array;

    private static function registerHook(string $hook): void
    {
        Hook::registerCallback(
            $hook,
            fn(...$args) => System::getRegisteredService(static::class)(...$args)
        );
    }
}
