<?php

declare(strict_types=1);

namespace app\vendor\apexl\io\src\Io\modules\system\dtos;

use app\module\newtonsTrailers\Dto\Dto;
use Symfony\Component\Console\Helper\QuestionHelper;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;

final readonly class CreateModuleDto extends Dto
{
    private function __construct(
        public string $name,
        public bool $routes,
        public bool $services,
        public bool $hooks,
        public bool $menus,
        public bool $permissions,
    ) {
    }

    public static function fromUserInput(
        InputInterface $input,
        OutputInterface $output,
        QuestionHelper $helper
    ): CreateModuleDto {
        return new CreateModuleDto(
            name: $input->getArgument('name'),
            routes: $helper->ask($input, $output, self::questionBool('Does the module register routes?')),
            services: $helper->ask($input, $output, self::questionBool('Does the module register services?')),
            hooks: $helper->ask($input, $output, self::questionBool('Does the module register hooks?', false)),
            menus: $helper->ask($input, $output, self::questionBool('Does the module register menus?', false)),
            permissions: $helper->ask(
                $input,
                $output,
                self::questionBool('Does the module register permissions?', false)
            ),
        );
    }

    private static function questionBool(
        string $question,
        bool $default = true
    ): ConfirmationQuestion {
        return new ConfirmationQuestion(sprintf('%s (%s) ', $question, $default ? 'Y/n' : 'y/N'), $default);
    }


}
