<?php

declare(strict_types=1);

namespace app\vendor\apexl\io\src\Io\modules\system\commands;

use apexl\Io\includes\System;
use app\module\newtonsTrailers\Service\Cache;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(name: 'cache:clear', description: 'Remove item(s) from the cache')]
class CacheClearCommand extends Command
{
    protected function configure(): void
    {
        $this->addArgument('key', null, 'The key to clear from the cache.  If empty, all items will be cleared.');
    }

    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $cache = System::getRegisteredService(Cache::class);

        $key = $input->getArgument('key');

        if (!$key) {
            $cache->clear();
            $io->success('Purged all items from the cache');

            return 0;
        }

        $cache->deleteItem($key);
        $io->success(sprintf('Purged \'%s\' from the cache', $key));

        return 0;
    }
}
