<?php

namespace apexl\Io\modules\system\controllers;

use apexl\Io\includes\System;

use apexl\Io\services\globalData;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class moduleController
{
    /**
     * @var \apexl\Io\services\globalData
     */
    public $globalData;
    public function __construct(globalData $globalData)
    {
        $this->globalData = $globalData;
    }

    /**
     * We allow any module to set 'global' data with middleware so we can grab it here.
     * This should contain information such as branding, user details, global meta etc.
     * @method GET
     * @return Response
     */
    public function getGlobalData(Request $request, Response $response)
    {
        return System::asJson($response, $this->globalData->getData(), 200);
    }
}
