<?php

declare(strict_types=1);

namespace apexl\Io\dto;

use apexl\entityCore\enums\Casts;

final readonly class EntityField extends Dto
{
    public function __construct(
        public string $field,
        public Casts|string $type,
        public string $sqlType,
        public bool $required,
        public ?string $length,
    ) {}

    public function is(string $field): bool
    {
        return $this->field === $field;
    }
}
