<?php

declare(strict_types=1);

namespace apexl\Io\modules\system\hooks;

use apexl\Io\collections\CommandCollection;
use apexl\Io\hooks\AbstractHook;
use app\vendor\apexl\io\src\Io\modules\system\commands\CacheClearCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\CacheViewCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\DumpConfigCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\ModuleCreateCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\ModuleListCommand;

final readonly class ConsoleCommands extends AbstractHook
{
    protected static function hooks(): array
    {
        return ['consoleCommands'];
    }

    public function __invoke(CommandCollection $commands): CommandCollection
    {
        $commands->add(CacheViewCommand::class);
        $commands->add(CacheClearCommand::class);
        $commands->add(ModuleListCommand::class);
        $commands->add(ModuleCreateCommand::class);
        $commands->add(DumpConfigCommand::class);

        return $commands;
    }
}
