<?php

declare(strict_types=1);

namespace apexl\Io\dto;

use Stringable;

readonly final class Raw extends Dto
{
    public function __construct(
        public string|float|int $value
    ) {}

    public static function string(string|float|int|Stringable $value, $quote = '\''): Raw
    {
        return new Raw(
            sprintf(
                '%1$s%2$s%1$s',
                $quote,
                str_replace(
                    $quote,
                    addslashes($quote),
                    $value
                )
            )
        );
    }

    public static function create(string|float|int $value): Raw
    {
        return new Raw($value);
    }
}
