<?php

declare(strict_types=1);

namespace apexl\Io\enums;

use Henzeb\Enumhancer\Concerns\Comparison;
use Henzeb\Enumhancer\Concerns\Getters;

enum HttpMethod
{
    use Getters;
    use Comparison;

    case GET;
    case POST;
    case PUT;
    case DELETE;
    case OPTIONS;
    case PATCH;


    public function forSlim(): string
    {
        return strtolower($this->name);
    }
}
