<?php

namespace apexl\Io\modules\installDisplay;

use apexl\Config\Configuration as Config;
use apexl\Io\includes\System;
use apexl\Io\services\Output;
use apexl\Io\services\pathUtility;
use apexl\Vault\Vault;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class installDisplayController
{
    public function __construct(
        protected pathUtility $path,
        protected Vault $database,
        protected Config $config
    ) {
    }

    /**
     * @method GET
     */
    public function start(Request $request, Response $response): Response
    {
        //We're installing
        Output::addResponse($request, ['thing' => 'stuff']);

        return System::asJson($response, []);
    }
}
