<?php

namespace apexl\Io\recommendedIncludes;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\Module;

/**
 * Class apiModule
 * Sets a number of expected system defaults - can be overridden with config.
 * @package apexl\Io\recommendedIncludes
 */
class apiModule extends Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('/api/v'.$this->apiVersion().'/'.strtolower((string) $this->getName()));
    }

    public function addActionRoute(HttpMethod $verb, string $name, string $pattern, $callable): apiModule
    {
        $this->addRoute($verb, $name, '/action/'.ltrim($pattern, '/'), $callable);

        return $this;
    }

    public function addDataRoute(HttpMethod $verb, string $name, string $pattern, $callable): apiModule
    {
        $this->addRoute($verb, $name, '/data/'.ltrim($pattern, '/'), $callable);

        return $this;
    }
}
