<?php

namespace apexl\Io\modules\installDisplay;

use apexl\Io\includes\Module;
use apexl\Io\includes\System;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\installDisplay
 */
class installDisplayModule extends Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('/');
    }

    public function routes(): void
    {
        //These are installing routes, so only include them if we need to install.
        if (System::$installing) {
            //@route /install
            $this->addRoute('GET', 'install.start', 'install', installDisplayController::class.':start');
        }
    }
}
