<?php

declare(strict_types=1);

namespace apexl\Io\collections;

use app\vendor\apexl\io\src\Io\modules\system\commands\DaedalusCommand;
use Arrayy\Collection\AbstractCollection;
use TypeError;

class DaedalusCommandCollection extends AbstractCollection
{
    /**
     * @param class-string<DaedalusCommand> $value
     * @param $key
     * @return DaedalusCommandCollection
     */
    public function add($value, $key = null): DaedalusCommandCollection
    {
        $this->assertIsCommandClass($value);

        return parent::add($value, $key);
    }

    /**
     * @throws TypeError
     */
    private function assertIsCommandClass(mixed $value): void
    {
        if (!is_string($value) || !is_a($value, DaedalusCommand::class, true)) {
            throw new TypeError(
                sprintf(
                    '%s must extend %s',
                    $value,
                    DaedalusCommand::class
                )
            );
        }
    }

    public function getType(): string
    {
        return 'string';
    }
}
