<?php

declare(strict_types=1);

use apexl\Config\Configuration;

if (!function_exists('env')) {
    /**
     * Get the value of an environment variable.
     *
     * @param string $key The name of the environment variable.
     * @param mixed $default The default value to return if the variable is not set.
     * @return mixed The value of the environment variable or the default value.
     */
    function env(string $key, mixed $default = null): mixed
    {
        return $_ENV[$key] ?? $default;
    }
}

if (!function_exists('config')) {
    /**
     * Get the value of a configuration setting.
     *
     * @param string $key The name of the configuration setting.
     * @param mixed $default The default value to return if the setting is not set.
     * @return mixed The value of the configuration setting or the default value.
     */
    function config(string $key, mixed $default = null): mixed
    {
        return Configuration::get($key) ?? $default;
    }
}