<?php

namespace apexl\Io\includes;

use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;

abstract readonly class Controller
{
    public function __construct(protected Output $output) {}

    protected function throw404(ResponseInterface $response): ResponseInterface
    {
        return $this->json($response, status: 404);
    }

    protected function json(ResponseInterface $response, array $data = [], int $status = 200): ResponseInterface
    {
        $data = array_merge($data, $this->output->getOutput());
        $response->getBody()->write(json_encode($data));

        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus($status);
    }
}
