<?php

declare(strict_types=1);

namespace apexl\Io\modules\authentication\controllers;

use apexl\Io\includes\Controller;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class authenticationController extends Controller
{
    public function authenticated(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return $this->json($response, [
            'authenticated' => $request->getAttribute('authenticated', true),
        ]);
    }
}
