<?php

declare(strict_types=1);

use apexl\Config\Configuration;
use apexl\Io\includes\Utils;
use apexl\Io\services\FilePaths;
use PHPMailer\PHPMailer\PHPMailer;

return [
    Configuration::class => function (FilePaths $filePaths): Configuration {
        $config = new Configuration();

        $files = Utils::getFilesInDirectory($filePaths->configDir(), ['php'], ['.local.php', '.example.php']);

        ksort($files, SORT_NATURAL); //ensure we load based on file order, not alpha (in case this matters).
        foreach ($files as $file) {
            $config->load($file);
        }

        return $config;
    },

    PHPMailer::class => function (): PHPMailer {
        $mail = new PHPMailer(true);

        //Allow config to set mailer settings.
        if (config('smtp')) {
            $mail->isSMTP();
            $mail->Host = config('smtp.host');
            $mail->SMTPAuth = config('smtp.auth', true);
            $mail->Username = config('smtp.username');
            $mail->Password = config('smtp.password');
            $mail->SMTPSecure = config('smtp.encryption', PHPMailer::ENCRYPTION_STARTTLS);
            $mail->Port = config('smtp.port');
            $mail->From = config('smtp.from');
        }

        return $mail;
    }
];
