<?php

namespace apexl\Io\modules\system;

use apexl\Io\includes\Module;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\system\controllers\globalDataController;
use apexl\Io\modules\system\controllers\globalSystemInfo;
use apexl\Io\modules\system\hooks\ConsoleCommands;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use app\vendor\apexl\io\src\Io\interfaces\ProvidesHooksInterface;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class systemModule extends Module implements ProvidesHooksInterface, ProvidesRoutesInterface
{
    public function routes(RouteManager $routeManager): void
    {
        //Get global data
        $routeManager->get(
            'system.globaldata',
            '/system/globalData',
            globalDataController::class . ':getGlobalData'
        );

        //get all available routes
        $routeManager->get('system.routes', '/system/routes', globalSystemInfo::class . ':getRoutes');
    }

    public function hooks(): array
    {
        return [
            ConsoleCommands::class,
        ];
    }
}
