<?php

namespace apexl\Io\recommendedIncludes;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\Module;
use apexl\Io\includes\RouteManager;

/**
 * Class displayModule
 * Sets a number of expected system defaults - can be overridden with config.
 * @package apexl\Io\recommendedIncludes
 */
class displayModule extends Module
{
    public function initialise(): void
    {
        parent::initialise();
        $this->setBaseRoute(sprintf('/display/v%d/%s', $this->apiVersion(), strtolower($this->getName())));
    }

    public function addDisplayRoute(
        RouteManager $routeManager,
        HttpMethod $verb,
        string $name,
        string $pattern,
        $callable
    ): displayModule {
        $this->addRoute(
            $routeManager,
            $verb,
            $name,
            '/display/' . ltrim($pattern, '/'),
            $callable
        );
        return $this;
    }
}
