<?php

declare(strict_types=1);

namespace apexl\Io;

use apexl\Config\Configuration;
use DI\Container;
use DI\DependencyException;
use DI\NotFoundException;


/**
 * Get the value of an environment variable.
 *
 * @param string $key The name of the environment variable.
 * @param mixed $default The default value to return if the variable is not set.
 * @return mixed The value of the environment variable or the default value.
 */
function env(string $key, mixed $default = null): mixed
{
    return $_ENV[$key] ?? $default;
}


function container(): Container
{
    global $container;

    return $container;
}


/**
 * Get the value of a configuration setting.
 *
 * @param string $key The name of the configuration setting.
 * @param mixed $default The default value to return if the setting is not set.
 * @return mixed The value of the configuration setting or the default value.
 */
function config(string $key, mixed $default = null): mixed
{
    try {
        return container()->get(Configuration::class)->get($key) ?? $default;
    } catch (DependencyException|NotFoundException $e) {
        exit($e->getMessage());
    }
}

/**
 * @template T of object
 * @param class-string<T> $shouldBeInstanceOf
 * @param-out class-string<T> $candidate
 */
function assertInstanceOf(string|object &$candidate, string $shouldBeInstanceOf, string $message = ''): void
{
    assert(
        is_subclass_of($candidate, $shouldBeInstanceOf),
        $message ?: sprintf('%s must implement / extend %s.', $candidate, $shouldBeInstanceOf),
    );
}
