<?php

declare(strict_types=1);

namespace apexl\Io\factories;

use apexl\Io\exceptions\ValidationException;
use apexl\Io\requestHelper\requestHelper;
use DI\Container;
use Psr\Http\Message\ServerRequestInterface;
use function apexl\Io\assertInstanceOf;

final readonly class RequestHelperFactory
{
    public function __construct(
        private Container $container,
    ) {}

    /**
     * @param class-string<RequestHelper> $helperClass
     * @throws ValidationException
     */
    public function make(string $helperClass, ServerRequestInterface $request): requestHelper
    {
        assertInstanceOf($helperClass, RequestHelper::class);

        return $this->container->make($helperClass, ['request' => $request]);
    }
}