<?php

declare(strict_types=1);

namespace apexl\Io\modules\system\hooks;

use apexl\Io\collections\DaedalusCommandCollection;
use apexl\Io\interfaces\AbstractHook;
use app\vendor\apexl\io\src\Io\modules\system\commands\CacheClearCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\CacheViewCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\DumpConfigCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\ModuleCreateCommand;
use app\vendor\apexl\io\src\Io\modules\system\commands\ModuleListCommand;

final readonly class ConsoleCommands implements AbstractHook
{
    public function hooks(): array
    {
        return ['consoleCommands'];
    }

    public function __invoke(DaedalusCommandCollection $commands): DaedalusCommandCollection
    {
        $commands->add(CacheViewCommand::class);
        $commands->add(CacheClearCommand::class);
        $commands->add(ModuleListCommand::class);
        $commands->add(ModuleCreateCommand::class);
        $commands->add(DumpConfigCommand::class);

        return $commands;
    }
}
