<?php

declare(strict_types=1);

namespace apexl\Io\services;

final readonly class FilePaths
{
    private string $configDir;
    private string $webRoot;


    public function __construct(
        private string $basePath,
        $configDir = './config',
        $webRoot = './web'
    ) {
        $this->configDir = realpath(sprintf('%s/%s', $this->basePath, $configDir));
        $this->webRoot = realpath(sprintf('%s/%s', $this->basePath, $webRoot));
    }

    public function basePath(?string $append = null): string
    {
        return $this->append($this->basePath, $append);
    }

    private function append(string $path, ?string $append = null): string
    {
        return sprintf(
            '%s%s',
            $path,
            $append ? sprintf('%s%s', DIRECTORY_SEPARATOR, $append) : ''
        );
    }

    public function configDir(?string $append = null): string
    {
        return $this->append($this->configDir, $append);
    }

    public function webRoot(?string $append = null): string
    {
        return $this->append($this->webRoot, $append);
    }

}