<?php

namespace apexl\Io\services;

use apexl\Vault\Vault;
use Arrayy\Type\ArrayCollection;

final readonly class TableDescriptionService
{
    private ArrayCollection $tableDescriptions;

    public function __construct(private Vault $db)
    {
        $this->tableDescriptions = new ArrayCollection();
    }

    public function describe($tableName, $forceRefresh = false)
    {
        if ($forceRefresh || !$this->tableDescriptions->has($tableName)) {
            $this->tableDescriptions->set($tableName, $this->db->newQuery()->describe($tableName)->fetchAll());
        }

        return $this->tableDescriptions->get($tableName) ?? null;
    }
}
