<?php

declare(strict_types=1);

namespace apexl\Io\factories;

use DI\Container;
use PHPMailer\PHPMailer\PHPMailer;

final readonly class PHPMailerFactory
{
    public function __construct(private Container $container) {}

    public function make(): PHPMailer
    {
        $mail = $this->container->make(PHPMailer::class, [
            'exceptions' => true,
        ]);

        //Allow config to set mailer settings.
        if (config('smtp')) {
            $mail->isSMTP();
            $mail->Host = config('smtp.host');
            $mail->SMTPAuth = config('smtp.auth', true);
            $mail->Username = config('smtp.username');
            $mail->Password = config('smtp.password');
            $mail->SMTPSecure = config('smtp.encryption', PHPMailer::ENCRYPTION_STARTTLS);
            $mail->Port = config('smtp.port');
            $mail->From = config('smtp.from');
        }

        return $mail;
    }
}