<?php

namespace apexl\Io\middleware\accessRequest;

use apexl\Io\services\HttpPaths;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Slim\Exception\HttpNotFoundException;
use Slim\Routing\RouteContext;

final readonly class accessRequest implements MiddlewareInterface
{
    public function __construct(private HttpPaths $httpPaths) {}

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): Response
    {
        $routeContext = RouteContext::fromRequest($request);
        $route = $routeContext->getRoute();

        // return NotFound for non existent route
        if (empty($route)) {
            throw new HttpNotFoundException($request);
        }

        // Set the current route object into path so we can access it anywhere in the app.
        $this->httpPaths->route = $route;

        return $handler->handle($request);
    }
}
