<?php

namespace apexl\Io\modules\system\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\services\GlobalData;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class globalDataController extends Controller
{
    public function __construct(private GlobalData $globalData, Output $output)
    {
        parent::__construct($output);
    }

    /**
     * We allow any module to set 'global' data with middleware so we can grab it here.
     * This should contain information such as branding, user details, global meta etc.
     * @method GET
     */
    public function getGlobalData(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return $this->json($response, $this->globalData->getData());
    }

    /**
     * @method DELETE
     */
    public function clearRouteCache(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return $this->json($response, $this->globalData->getData());
    }
}
