<?php

namespace apexl\Io\modules\system\controllers;

use apexl\Io\services\GlobalData;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class moduleController
{
    /**
     * @var \apexl\Io\services\GlobalData
     */
    public $globalData;

    public function __construct(GlobalData $globalData)
    {
        $this->globalData = $globalData;
    }

    /**
     * We allow any module to set 'global' data with middleware so we can grab it here.
     * This should contain information such as branding, user details, global meta etc.
     * @method GET
     * @return Response
     */
    public function getGlobalData(Request $request, Response $response)
    {
        return $this->json($response, $this->globalData->getData(), 200);
    }
}
